;*************************************************************************
;
;         PIC 16F876(A) - Laser Rangefinder Display Decoder .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 19.12.2009
;  Status    : A0.1                 Known Bugs : non
;  Fuses     : HS On, CP off, WDT off, BODEN on, PWRTE on, LVP off, 
;              DEBUG off, CPD off
;
;  Die Schaltung wird an den Kommunikationsbus zwischen C8051-Microcontroller
;  und Display-Controller HT1621B angeschlossen und hrt die Kommunikation mit.
;  Im PIC wird das Display-RAM nachgebildet und dann komplett per RS232 in
;  ASCII zur weiteren Analyse ausgegeben.
;
;  Microcontroller C8051F310 : Pin3:GND;[Pin4:VDD];Pin22:Data;Pin23:/WR;Pin24:/CS
;  Achtung : 3.3V Level auf dem Bussystem !
;
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 02 |   O  | n.c.
; | Port A RA1 Pin 03 |   O  | n.c.
; | Port A RA2 Pin 04 |   O  | n.c.
; | Port A RA3 Pin 05 |   O  | n.c.
; | Port A RA4 Pin 06 |   O  | n.c. (Achtung - OpenCollector Ausgang!)
; | Port A RA5 Pin 07 |   O  | n.c.
; |
; | Port B RB0 Pin 21 |   I  | /CS - Chipselect-Signal 
; | Port B RB1 Pin 22 |   I  | /WR - Write-Signal
; | Port B RB2 Pin 23 |   I  | DATA - Daten-Signal
; | Port B RB3 Pin 24 |   I  | n.c.
; | Port B RB4 Pin 25 |   I  | n.c.
; | Port B RB5 Pin 26 |   I  | n.c.
; | Port B RB6 Pin 27 |   I  | n.c.
; | Port B RB7 Pin 28 |   I  | n.c.
; |
; | Port C RC0 Pin 11 |   O  | n.c.
; | Port C RC1 Pin 12 |   O  | n.c.
; | Port C RC2 Pin 13 |   O  | n.c.
; | Port C RC3 Pin 14 | SCK  | SPI Clock Ausgang [nicht nicht benutzt]
; | Port C RC4 Pin 15 | SDI  | SPI Daten Eingang [nicht nicht benutzt]
; | Port C RC5 Pin 16 | SDO  | SPI Daten Ausgang [nicht nicht benutzt]
; | Port C RC6 Pin 17 |  TX  | TX RS232 115200 Baud
; | Port C RC7 Pin 18 |  RX  | RX RS232 115200 Baud
;
; Oszillator :  20 Mhz -> 200ns pro Zyklus
;
;*************************************************************************

	LIST      P=16F876;, F=INHX8M  
	#include "p16f876.inc"     

	__CONFIG  _HS_OSC & _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _LVP_OFF & _DEBUG_OFF & _CPD_OFF

BANK0:	MACRO
	bcf 	STATUS, RP0	;
	bcf 	STATUS, RP1	; Auf Bank 0 switchen
	ENDM
BANK1:	MACRO
	bsf 	STATUS, RP0	;
	bcf 	STATUS, RP1	; Auf Bank 1 switchen
	ENDM
BANK2:	MACRO
	bcf 	STATUS, RP0	;
	bsf 	STATUS, RP1	; Auf Bank 2 switchen
	ENDM
BANK3:	MACRO
	bsf 	STATUS, RP0	;
	bsf 	STATUS, RP1	; Auf Bank 3 switchen
	ENDM
	
#define BCS  		0x00 	; PORTB,0 : Chipselect
#define BWR  		0x01	; PORTB,1 : Write
#define BDAT		0x02	; PORTB,2 : Data
	
#define	T1             	0x20    ; Temp-Speicher 1
#define	T2            	0x21    ; Temp-Speicher 2
#define	T3             	0x22    ; Temp-Speicher 3
#define	T4		0x23	; Temp-Speicher 4

#define	W_TEMP		0x27	; fr ISR-Routine
#define	STATUS_TEMP	0x28	; fr ISR-Routine
#define	PCLATH_TEMP	0x29	; fr ISR-Routine
	
#define	DM0		0x30	; Display-Mem 0
#define	DM1		0x31	; Display-Mem 1 
#define	DM2		0x32	; Display-Mem 2
#define	DM3		0x33	; Display-Mem 3
#define	DM4		0x34	; Display-Mem 4
#define	DM5		0x35	; Display-Mem 5
#define	DM6		0x36	; Display-Mem 6
#define	DM7		0x37	; Display-Mem 7
#define	DM8		0x38	; Display-Mem 8
#define	DM9		0x39	; Display-Mem 9
#define	DMA		0x3A	; Display-Mem A
#define	DMB		0x3B	; Display-Mem B
#define	DMC		0x3C	; Display-Mem C
#define	DMD		0x3D	; Display-Mem D
#define	DME		0x3E	; Display-Mem E
#define	DMF		0x3F	; Display-Mem F
	
;*************************************************************************
; Anweisung fr Bootloader - nicht ndern
;*************************************************************************

	ORG     0x0000		; Speicherstelle 0
	clrf    STATUS		; STATUS lschen
	movlw   0x00		; 00 nach W
	movwf   PCLATH		; PCLATH auf 00
	goto    INIT		; Zum Programmstart

;*************************************************************************
; Anweisung fr Interrupt Service Routine
;*************************************************************************
	
	ORG     0x0004          ; Speicherstelle 04
	goto	ISRR	        ; Interrupt-Vektor falls bentigt
	
;*************************************************************************
; INIT - Erster Programmstart
;*************************************************************************
		
INIT    BANK1			; Bank 1 whlen     	
	
	movlw 	0x06
	movwf	ADCON1		; A/D Wandler abschalten
	
	movlw 	B'11000000'     ; RA0..RA5 Ausgang nicht benutzt
 	movwf   TRISA		;

	movlw	B'11111111'	; RB0..RB7 Eingang	
 	movwf   TRISB		;
 	
 	movlw 	B'11010000'     ; SCK, SDO Ausgang (TX wird spter gendert)
 	movwf   TRISC		;
 	
 	movlw 	B'00000000'	; SPI Mode
	movwf 	SSPSTAT 	; time sampling

 	BANK0			; Bank 0 whlen

	; Init der Seriellen Schnittstelle
	; fr schreiben sowie mit Interrupt fr Lesen
		
	BANK1			; Bank 1 anwhlen
	; movlw	0x81		; 9600 Baud
	; movlw	0x40		; 19200 Baud
	; movlw	0x2A		; 28800 Baud
	movlw	0x1F		; 38400 Baud
	; movlw	0x14		; 57600 Baud
	; movlw	0x0A		; 115200 Baud 

	movwf	SPBRG		;  
	movlw	B'00100100'	; TX Enablen, Baudrate High
	movwf	TXSTA		;
	bcf	PIE1,RCIE	; Receive Interrupt Enable nicht freischalten
	BANK0			; Bank 0 anwhlen
	movlw	B'10010000'	; Seriellen Port freischalten 
	movwf	RCSTA		;
	bcf	INTCON,PEIE	; Peripheral Interrupt Enable nicht freischalten
	bcf	INTCON,GIE	; Global Interrupt Enable nicht freischalten
 	
	goto	START		; Programm starten
	
;*************************************************************************
; START - Programmstart
;*************************************************************************

START	btfss	PORTB,BCS	; CS Grundzustand High ?
	goto	START		;
	
	clrf	DM0		;
	clrf	DM1		;
	clrf	DM2		;
	clrf	DM3		;
	clrf	DM4		;
	clrf	DM5		;
	clrf	DM6		;
	clrf	DM7		;
	clrf	DM8		;
	clrf	DM9		;
	clrf	DMA		;
	clrf	DMB		;
	clrf	DMC		;
	clrf	DMD		;
	clrf	DME		;
	clrf	DMF		;
	
	; Ok, Bus ist im Ruhezustand
	
START1	btfsc	PORTB,BCS	; CS auf Low ?
	goto	START1		; los gehts

CB3	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	CB3		;
CB3A	BTFSS	PORTB,BWR	; 
	GOTO	CB3A		; 
	BTFSS	PORTB,BDAT	; 1 ?
	GOTO	START		; 

CB2	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	CB2		;
CB2A	BTFSS	PORTB,BWR	; 
	GOTO	CB2A		; 
	BTFSC	PORTB,BDAT	; 0 ?
	GOTO	START		; 
	
CB1	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	CB1		;
CB1A	BTFSS	PORTB,BWR	; 
	GOTO	CB1A		; 
	BTFSS	PORTB,BDAT	; 1 ?
	GOTO	START		; 	

AB6	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	AB6		;
AB6A	BTFSS	PORTB,BWR	; 
	GOTO	AB6A		; 
	BTFSC	PORTB,BDAT	; 0 ?
	GOTO	START		; 	

AB5	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	AB5		;
AB5A	BTFSS	PORTB,BWR	; 
	GOTO	AB5A		; 
	BTFSC	PORTB,BDAT	; 0 ?
	GOTO	START		; 	

AB4	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	AB4		;
AB4A	BTFSS	PORTB,BWR	; 
	GOTO	AB4A		; 
	BTFSC	PORTB,BDAT	; 0 ?
	GOTO	START		; 	

AB3	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	AB3		;
AB3A	BTFSS	PORTB,BWR	; 
	GOTO	AB3A		; 
	BTFSC	PORTB,BDAT	; 0 ?
	GOTO	START		; 	

AB2	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	AB2		;
AB2A	BTFSS	PORTB,BWR	; 
	GOTO	AB2A		; 
	BTFSC	PORTB,BDAT	; 0 ?
	GOTO	START		; 	

AB1	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	AB1		;
AB1A	BTFSS	PORTB,BWR	; 
	GOTO	AB1A		; 
	BTFSC	PORTB,BDAT	; 0 ?
	GOTO	START		; 	

	; Einlesen der eigentlichen Display-Daten

	; Byte 0
	
R07	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R07		;
R07A	BTFSS	PORTB,BWR	; 
	GOTO	R07A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM0,7		;
R06	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R06		;
R06A	BTFSS	PORTB,BWR	; 
	GOTO	R06A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM0,6		;
R05	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R05		;
R05A	BTFSS	PORTB,BWR	; 
	GOTO	R05A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM0,5		;
R04	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R04		;
R04A	BTFSS	PORTB,BWR	; 
	GOTO	R04A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM0,4		;
R03	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R03		;
R03A	BTFSS	PORTB,BWR	; 
	GOTO	R03A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM0,3		;
R02	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R02		;
R02A	BTFSS	PORTB,BWR	; 
	GOTO	R02A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM0,2		;
R01	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R01		;
R01A	BTFSS	PORTB,BWR	; 
	GOTO	R01A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM0,1		;
R00	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R00		;
R00A	BTFSS	PORTB,BWR	; 
	GOTO	R00A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM0,0		;

	; Byte 1
	
R17	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R17		;
R17A	BTFSS	PORTB,BWR	; 
	GOTO	R17A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM1,7		;
R16	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R16		;
R16A	BTFSS	PORTB,BWR	; 
	GOTO	R16A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM1,6		;
R15	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R15		;
R15A	BTFSS	PORTB,BWR	; 
	GOTO	R15A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM1,5		;
R14	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R14		;
R14A	BTFSS	PORTB,BWR	; 
	GOTO	R14A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM1,4		;
R13	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R13		;
R13A	BTFSS	PORTB,BWR	; 
	GOTO	R13A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM1,3		;
R12	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R12		;
R12A	BTFSS	PORTB,BWR	; 
	GOTO	R12A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM1,2		;
R11	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R11		;
R11A	BTFSS	PORTB,BWR	; 
	GOTO	R11A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM1,1		;
R10	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R10		;
R10A	BTFSS	PORTB,BWR	; 
	GOTO	R10A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM1,0		;

	; Byte 2
	
R27	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R27		;
R27A	BTFSS	PORTB,BWR	; 
	GOTO	R27A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM2,7		;
R26	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R26		;
R26A	BTFSS	PORTB,BWR	; 
	GOTO	R26A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM2,6		;
R25	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R25		;
R25A	BTFSS	PORTB,BWR	; 
	GOTO	R25A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM2,5		;
R24	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R24		;
R24A	BTFSS	PORTB,BWR	; 
	GOTO	R24A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM2,4		;
R23	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R23		;
R23A	BTFSS	PORTB,BWR	; 
	GOTO	R23A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM2,3		;
R22	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R22		;
R22A	BTFSS	PORTB,BWR	; 
	GOTO	R22A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM2,2		;
R21	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R21		;
R21A	BTFSS	PORTB,BWR	; 
	GOTO	R21A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM2,1		;
R20	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R20		;
R20A	BTFSS	PORTB,BWR	; 
	GOTO	R20A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM2,0		;

	; Byte 3
	
R37	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R37		;
R37A	BTFSS	PORTB,BWR	; 
	GOTO	R37A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM3,7		;
R36	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R36		;
R36A	BTFSS	PORTB,BWR	; 
	GOTO	R36A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM3,6		;
R35	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R35		;
R35A	BTFSS	PORTB,BWR	; 
	GOTO	R35A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM3,5		;
R34	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R34		;
R34A	BTFSS	PORTB,BWR	; 
	GOTO	R34A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM3,4		;
R33	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R33		;
R33A	BTFSS	PORTB,BWR	; 
	GOTO	R33A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM3,3		;
R32	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R32		;
R32A	BTFSS	PORTB,BWR	; 
	GOTO	R32A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM3,2		;
R31	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R31		;
R31A	BTFSS	PORTB,BWR	; 
	GOTO	R31A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM3,1		;
R30	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R30		;
R30A	BTFSS	PORTB,BWR	; 
	GOTO	R30A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM3,0		;

	; Byte 4
	
R47	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R47		;
R47A	BTFSS	PORTB,BWR	; 
	GOTO	R47A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM4,7		;
R46	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R46		;
R46A	BTFSS	PORTB,BWR	; 
	GOTO	R46A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM4,6		;
R45	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R45		;
R45A	BTFSS	PORTB,BWR	; 
	GOTO	R45A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM4,5		;
R44	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R44		;
R44A	BTFSS	PORTB,BWR	; 
	GOTO	R44A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM4,4		;
R43	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R43		;
R43A	BTFSS	PORTB,BWR	; 
	GOTO	R43A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM4,3		;
R42	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R42		;
R42A	BTFSS	PORTB,BWR	; 
	GOTO	R42A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM4,2		;
R41	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R41		;
R41A	BTFSS	PORTB,BWR	; 
	GOTO	R41A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM4,1		;
R40	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R40		;
R40A	BTFSS	PORTB,BWR	; 
	GOTO	R40A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM4,0		;

	; Byte 5
	
R57	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R57		;
R57A	BTFSS	PORTB,BWR	; 
	GOTO	R57A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM5,7		;
R56	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R56		;
R56A	BTFSS	PORTB,BWR	; 
	GOTO	R56A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM5,6		;
R55	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R55		;
R55A	BTFSS	PORTB,BWR	; 
	GOTO	R55A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM5,5		;
R54	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R54		;
R54A	BTFSS	PORTB,BWR	; 
	GOTO	R54A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM5,4		;
R53	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R53		;
R53A	BTFSS	PORTB,BWR	; 
	GOTO	R53A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM5,3		;
R52	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R52		;
R52A	BTFSS	PORTB,BWR	; 
	GOTO	R52A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM5,2		;
R51	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R51		;
R51A	BTFSS	PORTB,BWR	; 
	GOTO	R51A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM5,1		;
R50	BTFSC	PORTB,BWR	; WR auf Low ?
	GOTO	R50		;
R50A	BTFSS	PORTB,BWR	; 
	GOTO	R50A		; 
	BTFSC	PORTB,BDAT	; 1 oder 0
	BSF	DM5,0		;
			
	; Die ersten 6 Bytes reichen aus ? 
	; Alle Bits sind da, jetzt auf der Schnitte ausgeben
	
TOUT	; movlw	0x3C		; < Zeichen
	; call	SENDRS		;

	movf	DM0,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;	
	movf	DM1,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DM2,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DM3,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DM4,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DM5,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DM6,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DM7,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DM8,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DM9,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DMA,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DMB,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DMC,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DMD,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DME,W		;
	call 	SEND
	movlw	0x20		; Space
	call	SENDRS		;		
	movf	DMF,W		;
	call 	SEND
	
ENDTO	; movlw	0x3E		; > Zeichen
	; call	SENDRS		;
	movlw	0x0D		; CR
	call	SENDRS		;
	movlw	0x0A		; LF
	call	SENDRS		;
	GOTO	START		; und wieder von vorne

SEND	movwf	T1		; Zwischenspeichern
	movlw	0x08		; 8 Bits ausgeben
	movwf	T2		; Zaehler aktivieren
SENDL	movlw	0x30		; ASCII 0
	rlf	T1,F		; Bit holen
	btfsc	STATUS,C	; 
	movlw	0x31		; ASCII 1
	call	SENDRS		; ausgeben
	decfsz	T2,F		;
	Goto	SENDL		; schon 8 Bits geholt ?
	RETURN			; und zurueck

;*************************************************************************
; SendRS232
;*************************************************************************

SENDRS	movwf	TXREG		; Daten werden in W uebergeben 
	bsf     STATUS,RP0	;     	
CHECK2	btfss	TXSTA,TRMT	;
	goto	CHECK2		;	
	bcf	STATUS,RP0	;
	return			;

;*************************************************************************
; ISR-Routine zum Lesen der seriellen Schnitte
;*************************************************************************

ISRR	movwf 	W_TEMP 		;Copy W to TEMP register
	swapf 	STATUS,W 	;Swap status to be saved into W
	clrf 	STATUS 		;bank 0, regardless of current bank, Clears IRP,RP1,RP0
	movwf 	STATUS_TEMP 	;Save status to bank zero STATUS_TEMP register
	movf 	PCLATH, W 	;Only required if using pages 1, 2 and/or 3
	movwf 	PCLATH_TEMP 	;Save PCLATH into W
	clrf 	PCLATH 		;Page zero, regardless of current page

	movf	RCREG,W		; Daten-Byte von der seriellen Schnitte abholen
	
	; hier koennte man mit den empfangenen bytes was machen ...
			
ISRRE	movf 	PCLATH_TEMP, W 	;Restore PCLATH
	movwf 	PCLATH 		;Move W into PCLATH
	swapf 	STATUS_TEMP,W 	;Swap STATUS_TEMP register into W
				;(sets bank to original state)
	movwf 	STATUS 		;Move W into STATUS register
	swapf 	W_TEMP,F 	;Swap W_TEMP
	swapf 	W_TEMP,W 	;Swap W_TEMP into W
	retfie
	
	        END

	