;*************************************************************************
;
;             PIC 16F84 - Akku-Lader .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 24.07.2001
;  Status    : A1.0                 Known Bugs : whew ...
;  Fuses     : XT enabled, WDT disabled and PWRTE enabled
;
;  Comments  : 1. An die 4 Speicherbnke denken !!!!
;                 -Hex: 000-0FF, 100-1FF, 200-2FF, 300-3FF
;
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 17 |  Out | Ladestrom an/aus
; | Port A RA1 Pin 18 | In   | Passivierung Temp-Signal
; | Port A RA2 Pin 01 | In   | Passivierung Batt-Signal
; | Port A RA3 Pin 02 | In   | Zusatz-Ausgang fuer Frequenzmessung
; | Port A RA4 Pin 03 | In   | RTCC-Eingang fuer Frequenzmessung
; |                   |      |
; | Port B RB0 Pin  6 |  Out | D0 fuer Display
; | Port B RB1 Pin  7 |  Out | D1 fuer Display
; | Port B RB2 Pin  8 |  Out | D2 fuer Display
; | Port B RB3 Pin  9 |  Out | D3 fuer Display
; | Port B RB4 Pin 10 |  Out | En fuer Display
; | Port B RB5 Pin 11 |  Out | Rs fuer Display
; | Port B RB6 Pin 12 | In   | -
; | Port B RB7 Pin 13 | In   | -
;
; Oszillator :  10 Mhz -> 0.4 us pro Zyklus
;
; History: - 3Byte Binr Counter
;          - 3Byte Binr nach BCD Converter
;          - LCD-Ansteuerung
;          - RTCC an RA4
;*************************************************************************

	LIST    p=16F84  ; Prozessor definieren
	__config H'3DF9' ; Fuses definieren WDT off PWRT on CP off XT on

; Register Seite 1 definieren, da OPTION- und TRIS-Befehl abgekuendigt

ROPTION EQU     1       ; Options-Register
RTRISA  EQU     5       ; Ein/Ausgaenge Port A
RTRISB  EQU     6       ; Ein/Ausgaenge Port B

; Paar Flags definieren

RP1     EQU     6       ; Bank Flag im Status-Register
RP0     EQU     5       ; Bank Flag im Status-Register                                                       
RD      EQU     0       ; Start-Lesen im EECON1-Register
CARRY   EQU     0       ; Carry-Flag im Status-Register
ZER     EQU     2       ; Zero-Flag im Status-Register

; Definieren der RAM's
; 00 bis 0Bh sind fest zugeordneter Systemspeicher

RTCC            EQU     1       ; RTCC
PC              EQU     2       ; Programmcounter
STATUS          EQU     3       ; Statusregister
PORT_A          EQU     5       ; 4-BIT Port ( PA0 - PA3)
PORT_B          EQU     6       ; 8-BIT Port ( PB0 - PB8)
INTCON          EQU     0BH     ; Interruptsteuerregister
PCLATH          EQU     0AH     ; PC-Counter High Latch  

; Diese Bytes sind zur Steuerung des Internen EEPROMS

EEDATA          EQU     08      ; EEPROM Data Register
EEADR           EQU     09      ; EEPROM Adress Register
EECON1          EQU     08      ; EEPROM Control Register 1
EECON2          EQU     09      ; EEPROM Control Register 2

; Vereinfachung fuer die Portdefinition

LCDRS           EQU     5       ; PortRB5 RS-LCD
LCDEN           EQU     4       ; PortRB4 En-LCD

; Diese Bytes sind die Ram-Adressen fr das Programm

TMPA            EQU     0CH     ; Temp-Merker
TMPB            EQU     0DH     ; Temp-Merker       
TMPC            EQU     0EH     ; Temp-Merker
TMPD            EQU     0FH     ; Temp-Merker
R0              EQU     10H     ; BCD-Counter High
R1              EQU     11H     ; BCD-Counter Mid-High
R2              EQU     12H     ; BCD-Counter Mid-Low
LADSTAT         EQU     13H     ; BCD-Counter Low
H_BYTE          EQU     14H     ; Bin-Counter TEMP High
L_BYTE          EQU     15H     ; Bin-Counter TEMP Middle
TMPCNT          EQU     16H     ; Bin-Counter TEMP Low

;*************************************************************************
	
	ORG     0x000           ; Speicherstelle 00
	GOTO    RESVEK          ; Reset-Vektor

RESVEK  BSF     STATUS,RP0      ; Bank 1 anwaehlen
	MOVLW   B'11111110'     ; RA3-RA1 Eingang RA0 Ausgang
	MOVWF   RTRISA          ; 
	MOVLW   B'11000000'     ; RB7/RB6 Eingang, RB5-RB0 Ausgang
	MOVWF   RTRISB          ; 
	MOVLW   B'00100111'     ; Extern, RisingEdge, Teiler, 256
	MOVWF   ROPTION         ; Counter-Mode
	BCF     STATUS,RP0      ; Bank 0 auswaehlen
	CLRWDT                  ; Watchdog Timer zurcksetzen

;*************************************************************************
; START - Starteinstellungen
;*************************************************************************

START   MOVLW   B'00000000'     ;
	MOVWF   PORT_B          ; Alle Ltg. auf Low 
	CALL    WAIT2           ; Warten, bis Display aus Reset raus ist
	CALL    WAIT2           ; lieber noch laenger warten
	CALL    LCDINI          ; LCD-Grundmaske erzeugen
			 
STARTE  BSF     STATUS,RP0      ; Bank 1 anwaehlen
	BCF     RTRISA,0        ; RA0 auf Ausgang
	BCF     RTRISA,1        ; RA1 auf Ausgang
	BCF     RTRISA,2        ; RA2 auf Ausgang
	BCF     RTRISA,3        ; RA3 auf Ausgang
	MOVLW   B'00100111'     ; Extern, RisingEdge, Teiler, 256
	MOVWF   ROPTION         ; Counter-Mode
	BCF     STATUS,RP0      ; Bank 0 waehlen
	BCF     PORT_A,0        ; RA0 auf Low: kein Ladestrom 
	BCF     PORT_A,1        ; RA1 auf Low: kein Temp-Signal 
	BCF     PORT_A,2        ; RA2 auf Low: kein Batt-Signal
	BCF     PORT_A,3        ; RA3 auf Low: keine Eingangsimpulse
	CLRF    RTCC            ; TMR0 loeschen
	CLRWDT                  ; PRESCALER loeschen

	BSF     STATUS,RP0      ; Bank 1 anwaehlen
	BSF     RTRISA,2        ; RA2 auf Eingang, Batt-Signal waehlen
	BSF     RTRISA,3        ; RA3 auf Eingang, Eingangsimpulse
	BCF     STATUS,RP0      ; Bank 0 waehlen

	CALL    WAIT5           ; 1 Sekunde warten

	BSF     STATUS,RP0      ; Bank 1 anwaehlen
	BCF     RTRISA,3        ; RA3 auf Ausgang, keine Eingangsimpulse
	BCF     RTRISA,2        ; RA2 auf Ausgang, kein Batt-Signal
	BCF     STATUS,RP0      ; Bank 0 waehlen

	CALL    GETPRE          ; Prescaler abholen

	BSF     LADSTAT,0       ;
	CALL    B2_BCD          ;
	CALL    TICKS           ;

	BSF     STATUS,RP0      ; Bank 1 anwaehlen
	BCF     RTRISA,0        ; RA0 auf Ausgang
	BCF     RTRISA,1        ; RA1 auf Ausgang
	BCF     RTRISA,2        ; RA2 auf Ausgang
	BCF     RTRISA,3        ; RA3 auf Ausgang
	MOVLW   B'00100111'     ; Extern, RisingEdge, Teiler, 256
	MOVWF   ROPTION         ; Counter-Mode
	BCF     STATUS,RP0      ; Bank 0 waehlen
	BCF     PORT_A,0        ; RA0 auf Low: kein Ladestrom 
	BCF     PORT_A,1        ; RA1 auf Low: kein Temp-Signal 
	BCF     PORT_A,2        ; RA2 auf Low: kein Batt-Signal
	BCF     PORT_A,3        ; RA3 auf Low: keine Eingangsimpulse
	CLRF    RTCC            ; TMR0 loeschen
	CLRWDT                  ; PRESCALER loeschen

	BSF     STATUS,RP0      ; Bank 1 anwaehlen
	BSF     RTRISA,1        ; RA1 auf Eingang, Batt-Signal waehlen
	BSF     RTRISA,3        ; RA3 auf Eingang, Eingangsimpulse
	BCF     STATUS,RP0      ; Bank 0 waehlen

	CALL    WAIT5           ; 1 Sekunde warten

	BSF     STATUS,RP0      ; Bank 1 anwaehlen
	BCF     RTRISA,3        ; RA3 auf Ausgang, keine Eingangsimpulse
	BCF     RTRISA,1        ; RA1 auf Ausgang, kein Batt-Signal
	BCF     STATUS,RP0      ; Bank 0 waehlen

	CALL    GETPRE          ; Prescaler abholen

	BCF     LADSTAT,0       ;
	CALL    B2_BCD          ;
	CALL    TICKS           ;

	GOTO    STARTE          ;

;*************************************************************************
; GETPRE - Prescaler und RTCC abholen
;*************************************************************************

GETPRE  MOVF    RTCC,0          ; RTCC nach W
	MOVWF   H_BYTE          ; nach H_Byte
	CLRF    TMPA            ; TMPA loeschen
NOMAL   BCF     PORT_A,3        ; 
	BSF     PORT_A,3        ; Impuls auf Eingang
	BCF     PORT_A,3        ;
	INCF    TMPA,1          ;
	MOVF    H_BYTE,0        ; H_BYTE nach W
	XORWF   RTCC,0          ; Aenderung in RTCC ?
	BTFSC   STATUS,ZER      ;
	GOTO    NOMAL           ;
	MOVLW   H'0FF'          ; FF nach W
	MOVWF   L_BYTE          ; nach L_BYTE
	MOVF    TMPA,0          ; TMPA nach W
	SUBWF   L_BYTE,1        ; 
	INCF    L_BYTE,1        ;
	RETURN                  ; und zurueck

;*************************************************************************
; LCDINI - Initialisiert das LCD-Display
;*************************************************************************

LCDINI  MOVLW   B'00000010'     ; Startbedingung
	MOVWF   PORT_B          ;
	CALL    WAIT1           ;
	CALL    WAIT2           ;
	CALL    WAIT2           ; Nochmal extra lange Warten
	
	MOVLW   B'00101000'     ;
	CALL    PUSHFUNC        ; Function Set
	MOVLW   B'00001100'     ;
	CALL    PUSHFUNC        ; Display On Cursor On Cursor Blink
	MOVLW   B'00000001'     ;
	CALL    PUSHFUNC        ; Display Clear
	MOVLW   B'00000110'     ;
	CALL    PUSHFUNC        ; Entry Mode Set
	
	MOVLW   A' '            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A' '            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A' '            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'A'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'k'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'k'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'u'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'l'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'a'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'd'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'e'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'r'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A' '            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'D'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'G'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'1'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'S'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'F'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'J'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   D'64'           ; 64+128 Adresse fuer Zeile 2
	ADDLW   D'128'
	CALL    PUSHFUNC        ;
	MOVLW   A'B'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'.'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A':'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   D'74'           ; 64+128 Adresse fuer Zeile 2
	ADDLW   D'128'
	CALL    PUSHFUNC        ;
	MOVLW   A'T'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A'.'            ; 
	CALL    PUSHDAT         ; 
	MOVLW   A':'            ; 
	CALL    PUSHDAT         ; 
	RETURN
			 
;*************************************************************************
; PUSHFUNC - Uebertraegt mit 4 Bit die Funktionen
;*************************************************************************
							   
PUSHFUNC MOVWF   TMPA           ; W speichern in TMPA
	
	SWAPF   TMPA,0          ;
	ANDLW   B'00001111'     ; Oberes Nibble holen
	MOVWF   PORT_B          ; und ausgeben
	BCF     PORT_B,LCDRS    ; Da Befehl, RS auf Low
	CALL    WAIT1           ;

	MOVF    TMPA,0          ;
	ANDLW   B'00001111'     ; Unteres Nibble holen
	MOVWF   PORT_B          ; und ausgeben
	BCF     PORT_B,LCDRS    ; Da Befehl, RS auf Low
	CALL    WAIT1           ;

	RETURN                  ; und zurueck
	
;*************************************************************************
; PUSHDAT - Uebertraegt mit 4 Bit die Daten
;*************************************************************************
							   
PUSHDAT MOVWF   TMPA            ; W speichern in TMPA
	
	SWAPF   TMPA,0          ;
	ANDLW   B'00001111'     ; Oberes Nibble holen
	MOVWF   PORT_B          ; und ausgeben
	BSF     PORT_B,LCDRS    ; Da Daten, RS auf High
	CALL    WAIT1           ;

	MOVF    TMPA,0          ;
	ANDLW   B'00001111'     ; Unteres Nibble holen
	MOVWF   PORT_B          ; und ausgeben
	BSF     PORT_B,LCDRS    ; Da Daten, RS auf High
	CALL    WAIT1           ;

	RETURN                  ; und zurueck

;*************************************************************************
; WAIT1 - Steuert Enable und wartet auf Befehlsausfuehrung
;*************************************************************************

WAIT1   BSF     PORT_B,LCDEN    ; Enable bissle verlaengern
	MOVLW   D'2'            ;
	MOVWF   TMPD            ; 
LOOP1X  DECFSZ  TMPD,1          ;
	GOTO    LOOP1X          ;
	BCF     PORT_B,LCDEN    ; 

	MOVLW   D'1'            ; Auf die Ausfuehrung der Befehle warten
	MOVWF   TMPC            ; 
LOOP1   MOVLW   D'255'          ;
	MOVWF   TMPD            ;
LOOP2   DECFSZ  TMPD,1          ;
	GOTO    LOOP2           ;
	DECFSZ  TMPC,1          ;
	GOTO    LOOP1           ;

	RETURN                  ;

;*************************************************************************
; WAIT2 - Wartet auf die LCD-Startup-Zeit ab
;*************************************************************************

WAIT2   MOVLW   D'255'          ; 
	MOVWF   TMPC            ;  
LOOP12  MOVLW   D'255'          ;
	MOVWF   TMPD            ;
LOOP22  DECFSZ  TMPD,1          ;
	GOTO    LOOP22          ;
	DECFSZ  TMPC,1          ;
	GOTO    LOOP12          ;
	RETURN                  ;

;*************************************************************************
; B2_BCD - Wandelt eine 2Byte Binary in 3Byte BCD um 
;*************************************************************************

B2_BCD  BCF     STATUS,CARRY    ;
	MOVLW   D'16'           ;
	MOVWF   TMPA            ;
	CLRF    R0              ;
	CLRF    R1              ;
	CLRF    R2              ;
LOOP24  RLF     L_BYTE,1        ;
	RLF     H_BYTE,1        ;
	RLF     R2,1            ;
	RLF     R1,1            ;
	RLF     R0,1            ;

	DECFSZ  TMPA,1          ;
	GOTO    ADJDEC          ;
	RETURN

ADJDEC  MOVF    R2,0            ;
	MOVWF   TMPB            ;
	CALL    ADJBCD          ;
	MOVF    TMPB,0          ;
	MOVWF   R2              ;

	MOVF    R1,0            ;
	MOVWF   TMPB            ;
	CALL    ADJBCD          ;
	MOVF    TMPB,0          ;
	MOVWF   R1              ;

	MOVF    R0,0            ;
	MOVWF   TMPB            ;
	CALL    ADJBCD          ;
	MOVF    TMPB,0          ;
	MOVWF   R0              ;

	GOTO    LOOP24          ;

ADJBCD  MOVLW   H'03'           ;
	ADDWF   TMPB,0          ;
	MOVWF   TMPC            ;
	BTFSC   TMPC,3          ;
	MOVWF   TMPB            ;

	MOVLW   H'30'           ;
	ADDWF   TMPB,0          ;
	MOVWF   TMPC            ;
	BTFSC   TMPC,7          ;
	MOVWF   TMPB            ;
	RETURN                  ;

;*************************************************************************
; Ticks - Gibt den aktuellen Zaehlerstand aus
;*************************************************************************

TICKS   BTFSS   LADSTAT,0       ; TEMP oder BATT ?
	GOTO    TICKS1          ; 
	
	MOVLW   D'67'           ; 64+128 Adresse fuer Zeile 2
	ADDLW   D'128'          ;                 
	CALL    PUSHFUNC        ; LADSTAT,0 auf 1 = BATT
	GOTO    TICKS2          ;

TICKS1  MOVLW   D'77'           ; 64+128 Adresse fuer Zeile 2
	ADDLW   D'128'          ;
	CALL    PUSHFUNC        ; LADSTAT,0 auf 0 = TEMP
	
TICKS2  SWAPF   R0,0            ;
	ANDLW   B'00001111'     ;
	ADDLW   D'48'           ; in ASCII konvertieren
	CALL    PUSHDAT         ; auf Display ausgeben
	MOVF    R0,0            ;
	ANDLW   B'00001111'     ;
	ADDLW   D'48'           ; in ASCII konvertieren
	CALL    PUSHDAT         ; auf Display ausgeben

	SWAPF   R1,0            ;
	ANDLW   B'00001111'     ;
	ADDLW   D'48'           ; in ASCII konvertieren
	CALL    PUSHDAT         ; auf Display ausgeben
	MOVF    R1,0            ;
	ANDLW   B'00001111'     ;
	ADDLW   D'48'           ; in ASCII konvertieren
	CALL    PUSHDAT         ; auf Display ausgeben

	SWAPF   R2,0            ;
	ANDLW   B'00001111'     ;
	ADDLW   D'48'           ; in ASCII konvertieren
	CALL    PUSHDAT         ; auf Display ausgeben
	MOVF    R2,0            ;
	ANDLW   B'00001111'     ;
	ADDLW   D'48'           ; in ASCII konvertieren
	CALL    PUSHDAT         ; auf Display ausgeben
		  
	RETURN                  ; bis zum bitteren Ende

;*************************************************************************
; WAIT5 - Wartet 500ms oder 1sec ab
; Eine Zeitdauer von einer halben Sekunde warten
; 1000ms = C:10 - B:249 - A:250
; 500ms = C:5 - B:249 - A:250
; ges: (((((TMPA*4)+4)*TMPB)+4)*TMPC)+1
;*************************************************************************

WAIT5   MOVLW   D'10'           ;        A
	MOVWF   TMPC            ;        A
LOOPC   MOVLW   D'249'          ;     M
	MOVWF   TMPB            ;     M
LOOPB   MOVLW   D'250'          ;  I
	MOVWF   TMPA            ;  I
LOOPA   NOP                     ;  I
	DECFSZ  TMPA,1          ;  I
	GOTO    LOOPA           ;  I
	DECFSZ  TMPB,1          ;     M
	GOTO    LOOPB           ;     M
	DECFSZ  TMPC,1          ;        A
	GOTO    LOOPC           ;        A
	RETURN                  ;

;*************************************************************************

	END                     ; das wars dann
