;*************************************************************************
;
;         PIC 16F84(A) - LTC1090 / LTC1290 Reader .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 14.08.2005
;  Status    : A1.0                 Known Bugs : whew ...
;  Fuses     : XT enabled, WDT disabled and PWRTE enabled
;
;  Comments  : 1. An die 4 Speicherbaenke denken !!!!
;                 -Hex: 000-0FF, 100-1FF, 200-2FF, 300-3FF
;
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 17 | In   | Modus
; | Port A RA1 Pin 18 | In   | Trigger
; | Port A RA2 Pin 01 |  Out | Seriell Out nach RS232
; | Port A RA3 Pin 02 | In   | IC-Select
; | Port A RA4 Pin 03 | In   | nix
; |                   |      |
; | Port B RB0 Pin  6 |  Out | /CS von LTC090           
; | Port B RB1 Pin  7 |  Out | SCLK von LTC1090
; | Port B RB2 Pin  8 |  Out | DIN von LTC1090
; | Port B RB3 Pin  9 | In   | DOUT von LTC1090
; | Port B RB4 Pin 10 | In   | nix
; | Port B RB5 Pin 11 | In   | nix
; | Port B RB6 Pin 12 | In   | nix
; | Port B RB7 Pin 13 | In   | nix
;
; Oszillator :  10 Mhz -> 0.4 us pro Zyklus
;
; Bitdauer     1FH =   Zyklen fuer 52,08 Zyklen
; HalbBitdauer 0FH =   Zyklen fuer 26,04 Zyklen
;
; 19200 Baud, 8n1, direkt ueber MAX232 zu seriell
;
; Software verarbeitet LTC1090 und LTC1290 ohne Umstellung
;
; Wenn Modus (Pin 17) = Low dann Fast-Read-Out
; Wenn Modus (Pin 17) = High dann Triggered Read-Out
;
; Trigger (Pin 18) sind jeweils Low/High Flanken
;
; Wenn IC-Select (Pin 2) = High dann LTC1090
; Wenn IC-Select (Pin 2) = Low dann LTC1290
; (Funktion steht zur Zeit noch nicht zur Verfuegung)
;
; LTC 1090 Protokoll :
;
; Bit 0 Single / Differential
; Bit 1 Odd / Sign
; Bit 2 Select
; Bit 3 Select
; Bit 4 Unipolar / Bipolar
; Bit 5 MSB first / LSB first
; Bit 6 Word Length
; Bit 7 Word Length
; Bit 8..11 immer 1
;
; Channel Selection;
;
; CH0 : 1 0 0 0 1 1 1 0 1 1 1 1
; CH1 : 1 1 0 0 1 1 1 0 1 1 1 1
; CH2 : 1 0 0 1 1 1 1 0 1 1 1 1
; CH3 : 1 1 0 1 1 1 1 0 1 1 1 1
; CH4 : 1 0 1 0 1 1 1 0 1 1 1 1
; CH5 : 1 1 1 0 1 1 1 0 1 1 1 1
; CH6 : 1 0 1 1 1 1 1 0 1 1 1 1
; CH7 : 1 1 1 1 1 1 1 0 1 1 1 1
; (Single/Unipolar/MSBfirst/10BitWordlength)
;
;*************************************************************************

	LIST    p=16F84  ; Prozessor definieren
	__config H'3DF9' ; Fuses definieren WDT off PWRT on CP off XT on

; Register Seite 1 definieren, da OPTION- und TRIS-Befehl abgekuendigt

ROPTION EQU     1       ; Options-Register
RTRISA  EQU     5       ; Ein/Ausgaenge Port A
RTRISB  EQU     6       ; Ein/Ausgaenge Port B

; Paar Flags definieren

RP1     EQU     6       ; Bank Flag im Status-Register
RP0     EQU     5       ; Bank Flag im Status-Register                                                       
RD      EQU     0       ; Start-Lesen im EECON1-Register
CARRY   EQU     0       ; Carry-Flag im Status-Register
ZER     EQU     2       ; Zero-Flag im Status-Register

; Definieren der RAM's
; 00 bis 0Bh sind fest zugeordneter Systemspeicher

TMR0            EQU     1       ; TMR0
PC              EQU     2       ; Programmcounter
STATUS          EQU     3       ; Statusregister
PORT_A          EQU     5       ; 4-BIT Port ( PA0 - PA3)
PORT_B          EQU     6       ; 8-BIT Port ( PB0 - PB8)
INTCON          EQU     0BH     ; Interruptsteuerregister
PCLATH          EQU     0AH     ; PC-Counter High Latch  

; Diese Bytes sind zur Steuerung des Internen EEPROMS

EEDATA          EQU     08      ; EEPROM Data Register
EEADR           EQU     09      ; EEPROM Adress Register
EECON1          EQU     08      ; EEPROM Control Register 1
EECON2          EQU     09      ; EEPROM Control Register 2

; Diese Bytes sind die Ram-Adressen fuer das Programm

OUTBYTE         EQU     0CH     ; Uebergabe des Zeichens
BITCNT          EQU     0DH     ; Zaehler fuer Ausgabebits
TMPX            EQU     0EH     ; Zaehler fuer Delayschleifen
LTCOUT          EQU     0FH     ; Befehl an LTC
LTCINH          EQU     10H     ; Antwort von LTC High Byte
LTCINL          EQU     11H     ; Antwort von LTC Low Byte
NIBOUT          EQU     12H     ; 
NUMH            EQU     13H     ;
NUML            EQU     14H     ; 
TENK            EQU     15H     ; 
THOU            EQU     16H     ; 
HUND            EQU     17H     ; 
TENS            EQU     18H     ; 
ONES            EQU     19H     ;
LTC1090         EQU     1AH     ; Bit 0 entscheidet ob LTC1090

;*************************************************************************
	
	ORG     0x000           ; Speicherstelle 00
	GOTO    RESVEK          ; Reset-Vektor
	
	ORG     0x004           ; Speicherstelle 04
	GOTO    RESVEK          ; Interrupt-Vektor

RESVEK  BSF     STATUS,RP0      ; Bank 1 anwaehlen
	MOVLW   B'11111011'     ; RA0..RA1 Eingang, RA2 Ausgang
	MOVWF   RTRISA          ; 
	MOVLW   B'11111000'     ; RB7-RB3 Eingang, RB2..RB0 Ausgang
	MOVWF   RTRISB          ; 
	MOVLW   B'00000000'     ; kein Vorteiler u.s.w.
	MOVWF   ROPTION         ; 
	BCF     STATUS,RP0      ; Bank 0 auswaehlen
	MOVLW   B'11111111'     ; TIMER0 auf FF setzen
	MOVWF   TMR0            ; in TMR reinschreiben
	MOVLW   B'00000000'     ; 
	MOVWF   INTCON          ; Interrupts disablen

;*************************************************************************
; START - Starteinstellungen
;*************************************************************************

START   BTFSS   PORT_A,3        ; LTC1090 ?
	GOTO    STA1            ;
	BSF     LTC1090,0       ; Ja
	GOTO    STA2            ;

STA1    BCF     LTC1090,0       ; Nein

STA2    BSF     PORT_B,0        ; CS auf High
	BCF     PORT_B,1        ; SCLK auf Low
	BCF     PORT_B,2        ; DIN auf Low

	MOVLW   B'10001110'     ; CH0
	MOVWF   LTCOUT          ; in LTCOUT
	CALL    SENDLTC         ; Befehl an LTC senden 
	CALL    SENDLTC         ; nochmal an LTC senden und Antwort holen
	CALL    DATRAUS         ; Ergebnis  Raus

	MOVLW   B'11001110'     ; CH1
	MOVWF   LTCOUT          ; in LTCOUT
	CALL    SENDLTC         ; Befehl an LTC senden 
	CALL    SENDLTC         ; nochmal an LTC senden und Antwort holen
	CALL    DATRAUS         ; Ergebnis  Raus
	
	MOVLW   B'10011110'     ; CH2
	MOVWF   LTCOUT          ; in LTCOUT
	CALL    SENDLTC         ; Befehl an LTC senden 
	CALL    SENDLTC         ; nochmal an LTC senden und Antwort holen
	CALL    DATRAUS         ; Ergebnis  Raus
	
	MOVLW   B'11011110'     ; CH3
	MOVWF   LTCOUT          ; in LTCOUT
	CALL    SENDLTC         ; Befehl an LTC senden 
	CALL    SENDLTC         ; nochmal an LTC senden und Antwort holen
	CALL    DATRAUS         ; Ergebnis  Raus
	
	MOVLW   B'10101110'     ; CH4
	MOVWF   LTCOUT          ; in LTCOUT
	CALL    SENDLTC         ; Befehl an LTC senden 
	CALL    SENDLTC         ; nochmal an LTC senden und Antwort holen
	CALL    DATRAUS         ; Ergebnis  Raus
	
	MOVLW   B'11101110'     ; CH5
	MOVWF   LTCOUT          ; in LTCOUT
	CALL    SENDLTC         ; Befehl an LTC senden 
	CALL    SENDLTC         ; nochmal an LTC senden und Antwort holen
	CALL    DATRAUS         ; Ergebnis  Raus
	
	MOVLW   B'10111110'     ; CH6
	MOVWF   LTCOUT          ; in LTCOUT
	CALL    SENDLTC         ; Befehl an LTC senden 
	CALL    SENDLTC         ; nochmal an LTC senden und Antwort holen
	CALL    DATRAUS         ; Ergebnis  Raus
	
	MOVLW   B'11111110'     ; CH7
	MOVWF   LTCOUT          ; in LTCOUT
	CALL    SENDLTC         ; Befehl an LTC senden 
	CALL    SENDLTC         ; nochmal an LTC senden und Antwort holen
	CALL    DATRAUS         ; Ergebnis  Raus
	
	MOVLW   H'0D'           ; Carriage Return 0D
	MOVWF   OUTBYTE         ; nach OutByte
	CALL    SENDB           ; Byte wegschicken
	
	MOVLW   H'0A'           ; LineFeed 0A
	MOVWF   OUTBYTE         ; nach OutByte
	CALL    SENDB           ; Byte wegschicken

NEW01   BTFSS   PORT_A,0        ; Modus auf 1 ?
	GOTO    START           ; gleich weiterlaufen
	
	BTFSC   PORT_A,1        ; Trigger auf 0 ?
	GOTO    NEW01           ; noch nicht auf 0
	
	CALL    DELAYF          ;
	CALL    DELAYF          ; Entprellen
	CALL    DELAYF          ;
	
	BTFSS   PORT_A,1        ; Trigger auf 1 ?
	GOTO    NEW01           ; Trigger noch auf 0

	GOTO    START           ; und nochmal

;*************************************************************************
; NAME     : SENDB
; FUNKTION : Routine sendet 8 Bit im seriellen Protokoll ab
;            19200 Baud bei 10MHz, 8 Datenbits, keine Paritaet, 1 Stop-Bit
; EINGANG  : OUTBYTE
; AUSGANG  : Port_A,2
;*************************************************************************

SENDB   MOVLW   08H             ; Anzahl Datenbits - 8
	MOVWF   BITCNT          ; nach Bitcnt
	BCF     PORT_A,2        ; Start-Bit auf 0
	CALL    DELAYF          ; eine Bit-Zeit warten

TXBT    RRF     OUTBYTE,1       ; ein Bit ins Carry schieben
	BTFSC   STATUS,CARRY    ; 1 oder 0 ?
	GOTO    ISHI            ; 1 Bit
ISLO    BCF     PORT_A,2        ; 0 Bit senden
	CALL    DELAYF          ; eine Bit-Zeit warten
	GOTO    ROTAT           ;
ISHI    BSF     PORT_A,2        ; 1 Bit senden
	CALL    DELAYF          ; eine Bit-Zeit warten
	GOTO    ROTAT           ;

ROTAT   DECFSZ  BITCNT,1        ; eins weggesendet ...
	GOTO    TXBT            ; naechstes Bit holen

	BSF     PORT_A,2        ; Stop-Bit auf 1
	CALL    DELAYF          ; eine Bit-Zeit warten
	BSF     PORT_A,2        ; Stop-Bit auf 1    
	CALL    DELAYF          ; eine Bit-Zeit warten
	RETURN                  ; zurueck zur Routine

;*************************************************************************
; NAME     : DELAYF
; FUNKTION : Wartet die Zeitdauer eines Bits von 52,08us ab
;            Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
;            + 4 pro Loop -> (4*X)+8 Zyklen
; EINGANG  : -
; AUSGANG  : -
;*************************************************************************

DELAYF  MOVLW   01DH            ; Bitdelay nach W
	MOVWF   TMPX            ; nach TMPX
LOOP1   NOP                     ; nix tun
	DECFSZ  TMPX,1          ; eins weg ...
	GOTO    LOOP1           ; noch groesser Null
	RETURN

;*************************************************************************
; NAME     : DELAYH
; FUNKTION : Wartet die Zeitdauer eines halben Bits von 26,04us
;            Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
;            + 4 pro Loop -> (4*X)+8 Zyklen
; EINGANG  : -
; AUSGANG  : -
;*************************************************************************

DELAYH  MOVLW   00FH            ; HalfBitDelay nach W
	MOVWF   TMPX            ; nach TMPX
LOOP2   NOP                     ; nix tun
	DECFSZ  TMPX,1          ; eins weg ...
	GOTO    LOOP2           ; noch groesser Null
	RETURN

;*************************************************************************
; NAME     : SENDLTC
; FUNKTION : Sendet eine Botschaft ab 12 Bits ab und holt damit auch 
;            das Ergebnis der Wandlung ab
; EINGANG  : LTCOUT
; AUSGANG  : LTCINH, LTCINL
;*************************************************************************

SENDLTC BSF     PORT_B,0        ; CS auf High
	BCF     PORT_B,1        ; SCLK auf Low
	BCF     PORT_B,2        ; DIN auf Low

	BCF     PORT_B,0        ; CS auf Low
	
	MOVF    LTCOUT,0        ; LTCOUT nach W
	MOVWF   OUTBYTE         ; OUTBYTE 
	CLRF    LTCINH          ;
	CLRF    LTCINL          ;

	MOVLW   08H             ; Anzahl Datenbits - 8
	MOVWF   BITCNT          ; nach Bitcnt

TXBT1   RLF     OUTBYTE,1       ; ein Bit ins Carry schieben
	BTFSC   STATUS,CARRY    ; 1 oder 0 ?
	GOTO    ISHI1           ; 1 Bit
ISLO1   BCF     PORT_B,2        ; 0 Bit senden
	CALL    DELAYF          ; Warten
	GOTO    ROTAT1          ;
ISHI1   BSF     PORT_B,2        ; 1 Bit senden
	CALL    DELAYF          ; Warten
	GOTO    ROTAT1          ;

ROTAT1  BSF     PORT_B,1        ; SCLK auf High 
	CALL    DELAYF          ; Warten
	
	BTFSS   PORT_B,3        ; DOUT auf High ?
	GOTO    SETL1           ;
SETH1   BSF     STATUS,CARRY    ; DOUT = 1, Carry loeschen
	RLF     LTCINH,1        ; Nach links durchschieben
	GOTO    WEITER1         ;
SETL1   BCF     STATUS,CARRY    ; DOUT = 0, Carry loeschen        
	RLF     LTCINH,1        ; Nach links durchschieben
	GOTO    WEITER1         ;

WEITER1 BCF     PORT_B,1        ; SCLK auf Low
	DECFSZ  BITCNT,1        ; eins weggesendet ...
	GOTO    TXBT1           ; naechstes Bit holen

	MOVLW   H'0FF'          ; Rest mit 1er auffuellen
	MOVWF   OUTBYTE         ;

	MOVLW   04H             ; Anzahl Datenbits - 4
	MOVWF   BITCNT          ; nach Bitcnt

TXBT2   RLF     OUTBYTE,1       ; ein Bit ins Carry schieben
	BTFSC   STATUS,CARRY    ; 1 oder 0 ?
	GOTO    ISHI2           ; 1 Bit
ISLO2   BCF     PORT_B,2        ; 0 Bit senden
	CALL    DELAYF          ; Warten
	GOTO    ROTAT2          ;
ISHI2   BSF     PORT_B,2        ; 1 Bit senden
	CALL    DELAYF          ; Warten
	GOTO    ROTAT2          ;

ROTAT2  BSF     PORT_B,1        ; SCLK auf High 
	CALL    DELAYF          ; Warten
	
	BTFSS   PORT_B,3        ; DOUT auf High ?
	GOTO    SETL2           ;
SETH2   BSF     STATUS,CARRY    ; DOUT = 1, Carry loeschen
	RLF     LTCINL,1        ; Nach links durchschieben
	GOTO    WEITER2         ;
SETL2   BCF     STATUS,CARRY    ; DOUT = 0, Carry loeschen        
	RLF     LTCINL,1        ; Nach links durchschieben
	GOTO    WEITER2         ;
	
WEITER2 BCF     PORT_B,1        ; SCLK auf Low
	DECFSZ  BITCNT,1        ; eins weggesendet ...
	GOTO    TXBT2           ; naechstes Bit holen

	BSF     PORT_B,0        ; CS wieder auf High

	CALL    DELAYF          ; Warten auf Conversion-Ende                  
	CALL    DELAYF          ; Warten auf Conversion-Ende
	CALL    DELAYF          ; Warten auf Conversion-Ende                  
	CALL    DELAYF          ; Warten auf Conversion-Ende
	
	; Ergebnis richtig hinschieben
	
	BTFSS   LTC1090,0       ; LTC1090 Chip ?
	GOTO    LTC1290         ; Nein

	MOVLW   B'00001100'     ;
	ANDWF   LTCINL,1        ; untere 2 Bits maskieren
	RRF     LTCINL,1        ; schieben
	RRF     LTCINL,1        ; schieben
	
	RLF     LTCINH,0        ; nach links
	MOVWF   TMPX            ; nach W
	RLF     TMPX,1          ; nach links
	MOVLW   B'11111100'     ;
	ANDWF   TMPX,0          ; obere 6 Bits maskieren
	ADDWF   LTCINL,1        ; LTCINL und TMPX addieren

	RRF     LTCINH,1        ; eins schieben
	RRF     LTCINH,1        ; eins schieben
	RRF     LTCINH,1        ; eins schieben
	RRF     LTCINH,1        ; eins schieben
	RRF     LTCINH,1        ; eins schieben
	RRF     LTCINH,1        ; eins schieben
	MOVLW   B'00000011'     ; 
	ANDWF   LTCINH,1        ; untere 2 Bits maskieren
	
	RETURN                  ; zurueck zur Routine

LTC1290 MOVLW   B'00001111'     ; Bits maskieren
	ANDWF   LTCINH,0        ;
	MOVWF   TMPX            ; nach W
	SWAPF   TMPX,0          ; Nibbles tauschen nach W
	ADDWF   LTCINL,1        ; Addieren und nach LTCINL

	MOVLW   B'11110000'     ; Bits maskieren
	ANDWF   LTCINH,1        ;
	SWAPF   LTCINH,1        ; Nibbles tauschen

	RETURN                  ; zurueck zur Routine

;*************************************************************************
; NAME     : DATRAUS
; FUNKTION : Sendet das Ergebnis in einzelnen Zahlen raus
; EINGANG  : LTCINH, LTCINL
; AUSGANG  : 
;*************************************************************************

DATRAUS MOVF    LTCINH,0        ; LTCINH nach W
	MOVWF   NUMH            ; nach NUMH
	MOVF    LTCINL,0        ; LTCINL nach W
	MOVWF   NUML            ; nach NUML

	CALL    CO16BCD         ; 16Bit BinaerZahl in BCD wandeln

	MOVLW   D'048'          ; ASCII 0
	ADDWF   THOU,1          ; THOU + 48
	ADDWF   HUND,1          ; HUND + 48
	ADDWF   TENS,1          ; TENS + 48
	ADDWF   ONES,1          ; ONES + 48
	
	MOVF    THOU,0          ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ; Tausender senden
	
	MOVF    HUND,0          ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ; Hunderter senden
	
	MOVF    TENS,0          ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ; Zehner senden
	
	MOVF    ONES,0          ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ; Einer senden
	
	
	MOVLW   D'032'          ; Leerzeichen 
	MOVWF   OUTBYTE         ; nach OutByte
	CALL    SENDB           ; Byte wegschicken

	RETURN                  ; zurueck

;*************************************************************************
; NAME     : CO16BCD
; FUNKTION : 16Bit Binaer-Zahl zu BCD
;            Von Maxim ApplicationSheet DI_1298.asm von Ted Salazar 
; EINGANG  : NUMH, NUML
; AUSGANG  : TENK,THOU,HUND,TENS,ONES
;*************************************************************************

CO16BCD SWAPF   NUMH,0          ;
	ANDLW   H'0F'           ;   
	ADDLW   H'F0'           ;  
	MOVWF   THOU            ;
	ADDWF   THOU,1          ;
	ADDLW   H'E2'           ;
	MOVWF   HUND            ;
	ADDLW   H'32'           ;
	MOVWF   ONES            ;

	MOVF    NUMH,0          ;
	ANDLW   H'0F'           ;
	ADDWF   HUND,1          ;
	ADDWF   HUND,1          ;
	ADDWF   ONES,1          ;
	ADDLW   H'E9'           ;
	MOVWF   TENS            ;
	ADDWF   TENS,1          ;
	ADDWF   TENS,1          ;

	SWAPF   NUML,0          ;
	ANDLW   H'0F'           ;
	ADDWF   TENS,1          ;
	ADDWF   ONES,1          ;

	RLF     TENS,1          ;
	RLF     ONES,1          ;
	COMF    ONES,1          ;
	RLF     ONES,1          ;

	MOVF    NUML,0          ;
	ANDLW   H'0F'           ;
	ADDWF   ONES,1          ;
	RLF     THOU,1          ;

	MOVLW   H'07'           ;
	MOVWF   TENK            ;

	MOVLW   H'0A'           ;                  
LB1:    ADDWF   ONES,1          ;
	DECF    TENS,1          ;
	BTFSS   STATUS,CARRY    ;
	GOTO    LB1             ;
LB2:    ADDWF   TENS,1          ;
	DECF    HUND,1          ;
	BTFSS   STATUS,CARRY    ;
	GOTO    LB2             ;
LB3:    ADDWF   HUND,1          ;
	DECF    THOU,1          ;
	BTFSS   STATUS,CARRY    ;
	GOTO    LB3             ;
LB4:    ADDWF   THOU,1          ;
	DECF    TENK,1          ;
	BTFSS   STATUS,CARRY    ;
	GOTO    LB4             ;
	
	RETURN                  ;

;*************************************************************************
; NAME     : NIBSEND
; FUNKTION : Konvertiert ein Nibble und sendet dieses als Hex aus
; EINGANG  : NIBOUT
; AUSGANG  : -
;*************************************************************************

NIBSEND MOVF    NIBOUT,0        ; NIBOUT nach W
	ANDLW   B'00001111'     ; untere Bits maskieren
	MOVWF   NIBOUT          ; W nach NIBOUT
	MOVLW   D'010'          ; 10 nach W
	SUBWF   NIBOUT,0        ; NIBOUT - 10
	BTFSC   STATUS,CARRY    ; CARRY gesetzt ?
	GOTO    HEXME           ; Zahl zwischen 10..15
	
	MOVLW   D'048'          ; 48 nach W
	ADDWF   NIBOUT,0        ; 48 + NIBOUT nach W
	MOVWF   OUTBYTE         ; nach Outbyte
	CALL    SENDB           ; aussenden
	RETURN                  ; zurueck
HEXME   MOVLW   D'010'          ; 10 nach W
	SUBWF   NIBOUT,1        ; NIBOUT - 10 nach NIBOUT
	MOVLW   D'065'          ; 65 nach W
	ADDWF   NIBOUT,0        ; 65 + Nibout nach W
	MOVWF   OUTBYTE         ; nach Outbyte
	CALL    SENDB           ; aussenden
	RETURN                  ; zurueck
	
	END                     ; das wars dann
