;*************************************************************************
;
;         PIC 16F84(A) - YAESU FT-8800 Display Decoder .... by DG1SFJ
;
;  Copyright : DG1SFJ               Datum      : 18.04.2006
;  Status    : A1.2                 Known Bugs : whew ...
;  Fuses     : XT enabled, WDT disabled and PWRTE enabled
;
;*************************************************************************
;
; | Pin:              | I/O: | Function:
; --------------------------------------------------------------------------
; | Port A RA0 Pin 17 | In   | RS232 TTL IN vom Display rein
; | Port A RA1 Pin 18 | In   | 
; | Port A RA2 Pin 01 |  Out | RS232 TTL OUT zum Notebook
; | Port A RA3 Pin 02 | In   | 
; | Port A RA4 Pin 03 | In   | 
; |                   |      |
; | Port B RB0 Pin  6 |  Out |        
; | Port B RB1 Pin  7 |  Out | 
; | Port B RB2 Pin  8 |  Out | 
; | Port B RB3 Pin  9 | In   | 
; | Port B RB4 Pin 10 | In   | nix
; | Port B RB5 Pin 11 | In   | nix
; | Port B RB6 Pin 12 | In   | nix
; | Port B RB7 Pin 13 | In   | nix
;
; Oszillator :  10 Mhz -> 0.4 us pro Zyklus
;
; Bitdauer     1FH =   Zyklen fuer 52,08 Zyklen
; HalbBitdauer 0FH =   Zyklen fuer 26,04 Zyklen
;
; 19200 Baud, 8n1, direkt ueber MAX232 zu seriell
;
; ACHTUNG : STACK KOMPLETT AUSGEREIZT !!!
;           KEINE WEITERE CALL RETURN EBENE EINBAUEN !!!
;*************************************************************************

	LIST    p=16F84  ; Prozessor definieren
	__config H'3DF9' ; Fuses definieren WDT off PWRT on CP off XT on

; Register Seite 1 definieren, da OPTION- und TRIS-Befehl abgekuendigt

ROPTION         EQU     1       ; Options-Register
RTRISA          EQU     5       ; Ein/Ausgaenge Port A
RTRISB          EQU     6       ; Ein/Ausgaenge Port B

; Paar Flags definieren
	
RP1             EQU     6       ; Bank Flag im Status-Register
RP0             EQU     5       ; Bank Flag im Status-Register                                                       
RD              EQU     0       ; Start-Lesen im EECON1-Register
CARRY           EQU     0       ; Carry-Flag im Status-Register
ZER             EQU     2       ; Zero-Flag im Status-Register

; Definieren der RAM's
; 00 bis 0Bh sind fest zugeordneter Systemspeicher

TMR0            EQU     1       ; TMR0
PC              EQU     2       ; Programmcounter
STATUS          EQU     3       ; Statusregister
PORT_A          EQU     5       ; 4-BIT Port ( PA0 - PA3)
PORT_B          EQU     6       ; 8-BIT Port ( PB0 - PB8)
INTCON          EQU     0BH     ; Interruptsteuerregister
PCLATH          EQU     0AH     ; PC-Counter High Latch  

; Diese Bytes sind zur Steuerung des Internen EEPROMS

EEDATA          EQU     08      ; EEPROM Data Register
EEADR           EQU     09      ; EEPROM Adress Register
EECON1          EQU     08      ; EEPROM Control Register 1
EECON2          EQU     09      ; EEPROM Control Register 2

; Diese Bytes sind die Ram-Adressen fuer das Programm

OUTBYTE         EQU     0CH     ; Uebergabe des Zeichens
BITCNT          EQU     0DH     ; Zaehler fuer Ausgabebits
TMPX            EQU     0EH     ; Zaehler fuer Delayschleifen
MSTAT           EQU     0FH     ; Statusanzeigen
M01             EQU     10H     ; Speicher
M02             EQU     11H     ; Speicher
M03             EQU     12H     ; Speicher
M04             EQU     13H     ; Speicher
M05             EQU     14H     ; Speicher
M06             EQU     15H     ; Speicher
M07             EQU     16H     ; Speicher
M08             EQU     17H     ; Speicher
M09             EQU     18H     ; Speicher
M10             EQU     19H     ; Speicher
M11             EQU     1AH     ; Speicher
M12             EQU     1BH     ; Speicher
M13             EQU     1CH     ; Speicher
M14             EQU     1DH     ; Speicher
M15             EQU     1EH     ; Speicher
M16             EQU     1FH     ; Speicher
T01             EQU     20H     ; Speicher
T02             EQU     21H     ; Speicher
T03             EQU     22H     ; Speicher
TMPA            EQU     23H     ; Speicher
TMPB            EQU     24H     ; Speicher
F01             EQU     25H     ; Speicher
F02             EQU     26H     ; Speicher
F03             EQU     27H     ; Speicher
F04             EQU     28H     ; Speicher
F05             EQU     29H     ; Speicher
F06             EQU     2AH     ; Speicher
F07             EQU     2BH     ; Speicher
F08             EQU     2CH     ; Speicher
F09             EQU     2EH     ; Speicher
F10             EQU     2FH     ; Speicher
F11             EQU     30H     ; Speicher
F12             EQU     31H     ; Speicher
F13             EQU     32H     ; Speicher
F14             EQU     33H     ; Speicher
F15             EQU     34H     ; Speicher
F16             EQU     35H     ; Speicher
DISPRL          EQU     36H     ; Merker ob Rechtes oder linkes
				; Display da STACK bereits voll ...
;*************************************************************************
	
	ORG     0x000           ; Speicherstelle 00
	GOTO    RESVEK          ; Reset-Vektor
	
	ORG     0x004           ; Speicherstelle 04
	GOTO    RESVEK          ; Interrupt-Vektor

RESVEK  BSF     STATUS,RP0      ; Bank 1 anwaehlen
	MOVLW   B'11111011'     ; RA0..RA1 Eingang, RA2 Ausgang
	MOVWF   RTRISA          ; 
	MOVLW   B'11111000'     ; RB7-RB3 Eingang, RB2..RB0 Ausgang
	MOVWF   RTRISB          ; 
	MOVLW   B'00000000'     ; kein Vorteiler u.s.w.
	MOVWF   ROPTION         ; 
	BCF     STATUS,RP0      ; Bank 0 auswaehlen
	MOVLW   B'11111111'     ; TIMER0 auf FF setzen
	MOVWF   TMR0            ; in TMR reinschreiben
	MOVLW   B'00000000'     ; 
	MOVWF   INTCON          ; Interrupts disablen

;*************************************************************************
; START - Starteinstellungen
;*************************************************************************

START   CLRF    DISPRL          ; Display zuruecksetzen

	; Auf Luecke zwischen den Bytes warten um
	; den Frameanfang zu finden
	; Zw. 2..3ms Ruhe-Pegel (High) vor dem ersten Byte
	; 20 mal Full-Delay a 52us, damit ca. 1ms

	MOVLW   D'20'           ; 20 nach W 
	MOVWF   TMPA            ; 
RXLUEC  BTFSS   PORT_A,0        ; 
	GOTO    START           ; doch keine Luecke
	CALL    DELAYF          ; 52us warten
	DECFSZ  TMPA,1          ; vom Counter 1 abziehen
	GOTO    RXLUEC          ;
	
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M01             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M02             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M03             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M04             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M05             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M06             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M07             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M08             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M09             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M10             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M11             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M12             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M13             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M14             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M15             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   M16             ; 
	
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F01             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F02             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F03             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F04             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F05             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F06             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F07             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F08             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F09             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F10             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F11             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F12             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F13             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F14             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F15             ; 
	CALL    GETBY           ; Bytes abholen
	MOVF    OUTBYTE,0       ;
	MOVWF   F16             ; 

	GOTO    DISPOUT         ; Linke Anzeige ausgeben
	
DISPR   BSF     DISPRL,0        ; Merker, das Links schon ausgegeben
	
	MOVLW   D'32'           ; SPACE
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	MOVLW   D'32'           ; SPACE
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	MOVLW   D'32'           ; SPACE
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;

	MOVF    F01,0           ; Bytes umkopieren
	MOVWF   M01             ;
	MOVF    F02,0           ; Bytes umkopieren
	MOVWF   M02             ;
	MOVF    F03,0           ; Bytes umkopieren
	MOVWF   M03             ;
	MOVF    F04,0           ; Bytes umkopieren
	MOVWF   M04             ;
	MOVF    F05,0           ; Bytes umkopieren
	MOVWF   M05             ;
	MOVF    F06,0           ; Bytes umkopieren
	MOVWF   M06             ;
	MOVF    F07,0           ; Bytes umkopieren
	MOVWF   M07             ;
	MOVF    F08,0           ; Bytes umkopieren
	MOVWF   M08             ;
	MOVF    F09,0           ; Bytes umkopieren
	MOVWF   M09             ;
	MOVF    F10,0           ; Bytes umkopieren
	MOVWF   M10             ;
	MOVF    F11,0           ; Bytes umkopieren
	MOVWF   M11             ;
	MOVF    F12,0           ; Bytes umkopieren
	MOVWF   M12             ;
	MOVF    F13,0           ; Bytes umkopieren
	MOVWF   M13             ;
	MOVF    F14,0           ; Bytes umkopieren
	MOVWF   M14             ;
	MOVF    F15,0           ; Bytes umkopieren
	MOVWF   M15             ;
	MOVF    F16,0           ; Bytes umkopieren
	MOVWF   M16             ;

	GOTO    DISPOUT         ; Rechte Anzeige ausgeben

DISPF   MOVLW   H'0D'           ; CR+LF
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;

	MOVLW   H'0A'           ; CR+LF
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;

	GOTO    START           ; Alles fertig, neu starten

;*************************************************************************
; Status-Register zusammenbauen
; 7 : Dezimal Punkt MHz
; 6 : Dezimal Punkt kHz
; 5 : 5 kHz genutzt
; 4 : BUSY Flag
; 3..0 : 0..9 fuer S0 bis S9 SMeter
;*************************************************************************

DISPOUT CLRF    MSTAT           ; Statusregister loeschen
	
	BTFSC   M11,4           ; S1 ?
	INCF    MSTAT,1         ; MSTAT um eins erhoehen
	BTFSC   M11,0           ; S2 ?
	INCF    MSTAT,1         ; MSTAT um eins erhoehen
	BTFSC   M09,2           ; S3 ?
	INCF    MSTAT,1         ; MSTAT um eins erhoehen
	BTFSC   M07,6           ; S4 ?
	INCF    MSTAT,1         ; MSTAT um eins erhoehen
	BTFSC   M06,1           ; S5 ?
	INCF    MSTAT,1         ; MSTAT um eins erhoehen
	BTFSC   M05,4           ; S6 ?
	INCF    MSTAT,1         ; MSTAT um eins erhoehen
	BTFSC   M03,6           ; S7 ?
	INCF    MSTAT,1         ; MSTAT um eins erhoehen
	BTFSC   M03,2           ; S8 ?
	INCF    MSTAT,1         ; MSTAT um eins erhoehen
	BTFSC   M01,4           ; S9 ?
	INCF    MSTAT,1         ; MSTAT um eins erhoehen
	
	BTFSC   M09,0           ; Dezimal Punkt MHZ gesetzt ?
	BSF     MSTAT,7         ; ja
	BTFSC   M01,3           ; Dezimal Punkt kHz gesetzt ?
	BSF     MSTAT,6         ; ja
	BTFSC   M01,0           ; 5 kHz gesetzt ?
	BSF     MSTAT,5         ; ja
	BTFSC   M13,2           ; BUSY gesetzt ?
	BSF     MSTAT,4         ; ja

;*************************************************************************
; Umsortieren der Speicher M01 bis M16 auf den 
; Aufbau der Segmente nach M C N H G A K B F E Q J D
; wobei sich im MSB (TMPA) befinden sollen : M C N H G
; und im LSB (TMPB) : A K B F E Q J D
;
; Anmerkung : Stelle 6 // 2 (Muster A) 
;             Stelle 5 // 1 (Muster B)
;             Stelle 4 (Muster C)
;             Stelle 3 (Muster D)
;*************************************************************************

	MOVF    M01,0           ; M01 nach W
	MOVWF   T01             ; nach T01
	MOVF    M02,0           ; M02 nach W
	MOVWF   T02             ; nach T02
	MOVF    M03,0           ; M03 nach W
	MOVWF   T03             ; nach T03
	CALL    SORTA           ; Nach Muster A sortieren
	MOVF    TMPA,0          ; 
	MOVWF   M01             ; nach M01
	MOVF    TMPB,0          ; 
	MOVWF   M02             ; nach M02

	MOVF    M04,0           ; M04 nach W
	MOVWF   T01             ; nach T01
	MOVF    M05,0           ; M05 nach W
	MOVWF   T02             ; nach T02
	MOVF    M06,0           ; M06 nach W
	MOVWF   T03             ; nach T03
	CALL    SORTB           ; Nach Muster B sortieren
	MOVF    TMPA,0          ; 
	MOVWF   M03             ; nach M03
	MOVF    TMPB,0          ; 
	MOVWF   M04             ; nach M04
	
	MOVF    M06,0           ; M06 nach W
	MOVWF   T01             ; nach T01
	MOVF    M07,0           ; M07 nach W
	MOVWF   T02             ; nach T02
	MOVF    M08,0           ; M08 nach W
	MOVWF   T03             ; nach T03
	CALL    SORTC           ; Nach Muster C sortieren
	MOVF    TMPA,0          ; 
	MOVWF   M05             ; nach M05
	MOVF    TMPB,0          ; 
	MOVWF   M06             ; nach M06
	
	MOVF    M09,0           ; M09 nach W
	MOVWF   T01             ; nach T01
	MOVF    M10,0           ; M10 nach W
	MOVWF   T02             ; nach T02
	MOVF    M11,0           ; M11 nach W
	MOVWF   T03             ; nach T03
	CALL    SORTD           ; Nach Muster D sortieren
	MOVF    TMPA,0          ; 
	MOVWF   M07             ; nach M07
	MOVF    TMPB,0          ; 
	MOVWF   M08             ; nach M08
	
	MOVF    M11,0           ; M11 nach W
	MOVWF   T01             ; nach T01
	MOVF    M12,0           ; M12 nach W
	MOVWF   T02             ; nach T02
	MOVF    M13,0           ; M13 nach W
	MOVWF   T03             ; nach T03
	CALL    SORTA           ; Nach Muster A sortieren
	MOVF    TMPA,0          ; 
	MOVWF   M09             ; nach M09
	MOVF    TMPB,0          ; 
	MOVWF   M10             ; nach M10
	
	MOVF    M14,0           ; M14 nach W
	MOVWF   T01             ; nach T01
	MOVF    M15,0           ; M15 nach W
	MOVWF   T02             ; nach T02
	MOVF    M16,0           ; M16 nach W
	MOVWF   T03             ; nach T03
	CALL    SORTB           ; Nach Muster B sortieren
	MOVF    TMPA,0          ; 
	MOVWF   M11             ; nach M11
	MOVF    TMPB,0          ; 
	MOVWF   M12             ; nach M12

;*************************************************************************
; Nach dem Sortieren : 
; Stelle 6 : Speicher M01 // M02
; Stelle 5 : Speicher M03 // M04
; Stelle 4 : Speicher M05 // M06
; Stelle 3 : Speicher M07 // M08
; Stelle 2 : Speicher M09 // M10
; Stelle 1 : Speicher M11 // M12
;*************************************************************************

;*************************************************************************
; Konvertierung von 13 Segment auf ASCII
; Unterstuetzt werden nur 0..9 // A..Z // SPACE // -
;*************************************************************************

	; Umrechnung der Zahlen und Ziffern

	CLRF    M16             ; Speicher 16 loeschen fuer spaeter
	MOVF    M01,0           ; Stelle 6 wandeln
	MOVWF   TMPA            ;
	MOVF    M02,0           ;
	MOVWF   TMPB            ;
	CALL    TES01           ; Wandeln
	MOVF    M16,0           ; Ergebnis holen
	MOVWF   M01             ; in M01 ablegen

	CLRF    M16             ; Speicher 16 loeschen fuer spaeter
	MOVF    M03,0           ; Stelle 5 wandeln
	MOVWF   TMPA            ;
	MOVF    M04,0           ;
	MOVWF   TMPB            ;
	CALL    TES01           ; Wandeln
	MOVF    M16,0           ; Ergebnis holen
	MOVWF   M02             ; in M02 ablegen

	CLRF    M16             ; Speicher 16 loeschen fuer spaeter
	MOVF    M05,0           ; Stelle 4 wandeln
	MOVWF   TMPA            ;
	MOVF    M06,0           ;
	MOVWF   TMPB            ;
	CALL    TES01           ; Wandeln
	MOVF    M16,0           ; Ergebnis holen
	MOVWF   M03             ; in M03 ablegen

	CLRF    M16             ; Speicher 16 loeschen fuer spaeter
	MOVF    M07,0           ; Stelle 3 wandeln
	MOVWF   TMPA            ;
	MOVF    M08,0           ;
	MOVWF   TMPB            ;
	CALL    TES01           ; Wandeln
	MOVF    M16,0           ; Ergebnis holen
	MOVWF   M04             ; in M04 ablegen
	
	CLRF    M16             ; Speicher 16 loeschen fuer spaeter
	MOVF    M09,0           ; Stelle 2 wandeln
	MOVWF   TMPA            ;
	MOVF    M10,0           ;
	MOVWF   TMPB            ;
	CALL    TES01           ; Wandeln
	MOVF    M16,0           ; Ergebnis holen
	MOVWF   M05             ; in M05 ablegen

	CLRF    M16             ; Speicher 16 loeschen fuer spaeter
	MOVF    M11,0           ; Stelle 1 wandeln
	MOVWF   TMPA            ;
	MOVF    M12,0           ;
	MOVWF   TMPB            ;
	CALL    TES01           ; Wandeln
	MOVF    M16,0           ; Ergebnis holen
	MOVWF   M06             ; in M06 ablegen
	
	; Die ersten 3 Stellen ausgeben

	MOVF    M06,0           ; 
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	MOVF    M05,0           ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	MOVF    M04,0           ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	
	; Abfrage des MHz Punktes

	BTFSS   MSTAT,7         ; Dezimal-Punkt gesetzt ?
	CALL    WEI01           ;
	MOVLW   D'46'           ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	
	; Die naechsten 3 Stellen ausgeben

WEI01   MOVF    M03,0           ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	MOVF    M02,0           ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	MOVF    M01,0           ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;

	; Abfrage der kleinen 5 (fuer kHz)

WEI02   BTFSS   MSTAT,6         ; 5 kHz ausgeben ?
	CALL    WEI03           ;
	MOVLW   D'53'           ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	
	; Ausgabe des S-Meter-Wertes
	; Wenn kein Dezimal-Punkt, noch ein SPACE
	; Wenn kein kleiner 5er, noch ein SPACE

WEI03   MOVLW   D'32'           ; SPACE
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;

	BTFSC   MSTAT,7         ; MHz Punkt nicht genutzt ?
	GOTO    WEI10           ;
	MOVLW   D'32'           ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;

WEI10   BTFSC   MSTAT,5         ; 5 kHz nicht genutzt ?
	GOTO    WEI11           ;
	MOVLW   D'32'           ;
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;

WEI11   MOVLW   D'83'           ; S
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	
	MOVF    MSTAT,0         ;
	ANDLW   B'00001111'     ;  Bits maskieren
	ADDLW   D'48'           ; 0..9 ASCII
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;

	; Abfrage BUSY Flag

	BTFSS   MSTAT,4         ; BUSY
	GOTO    WEI04           ;
	MOVLW   D'33'           ; Ausrufungszeichen
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;
	GOTO    WEI05           ;

WEI04   MOVLW   D'32'           ; Leerzeichen wenn kein BUSY   
	MOVWF   OUTBYTE         ;
	CALL    SENDB           ;

WEI05   NOP                     ;   
	
	; Leider kein STACK mehr, deswegen Display Links und
	; Rechts unterscheiden per Merker-Bit ...

	BTFSS   DISPRL,0        ; Gesetzt ?
	GOTO    DISPR           ;
	GOTO    DISPF           ;

;*************************************************************************
; Einfachabfragen MSB 6 // 10 // 14 // 21 
;*************************************************************************

TES01   MOVF    TMPA,0          ; nach W
	SUBLW   D'6'            ; 6 ?
	BTFSC   STATUS,ZER      ;
	CALL    FB88            ;
	
	MOVF    TMPA,0          ; nach W
	SUBLW   D'10'           ; 10 ?
	BTFSC   STATUS,ZER      ;
	CALL    FB77            ;
	
	MOVF    TMPA,0          ; nach W
	SUBLW   D'14'           ; 14 ?
	BTFSC   STATUS,ZER      ;
	CALL    FB78            ;
	
	MOVF    TMPA,0          ; nach W
	SUBLW   D'21'           ; 21 ?
	BTFSC   STATUS,ZER      ;
	CALL    FB82            ;

	GOTO    TES02           ; Zweifach Abfragen

FB88    MOVLW   D'88'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB77    MOVLW   D'77'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB78    MOVLW   D'78'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB82    MOVLW   D'82'           ;
	MOVWF   M16             ;
	RETURN                  ;
	
;*************************************************************************
; Zweifachabfragen MSB 5 // 12 // 24
;*************************************************************************

TES02   MOVF    TMPA,0          ; nach W
	SUBLW   D'5'            ; 5 ?
	BTFSC   STATUS,ZER      ;
	CALL    DU05            ;
	
	MOVF    TMPA,0          ; nach W
	SUBLW   D'12'           ; 12 ?
	BTFSC   STATUS,ZER      ;
	CALL    DU12            ;
	
	MOVF    TMPA,0          ; nach W
	SUBLW   D'24'           ; 24 ?
	BTFSC   STATUS,ZER      ;
	CALL    DU24            ;
	
	GOTO    TES03           ; Tabellen Abfragen
	
DU05    MOVF    TMPB,0          ; nach W
	SUBLW   D'88'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB75            ;
	
	MOVF    TMPB,0          ; nach W
	SUBLW   D'145'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB83            ;

	RETURN                  ;

DU12    MOVF    TMPB,0          ; nach W
	SUBLW   D'60'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB87            ;
	
	MOVF    TMPB,0          ; nach W
	SUBLW   D'185'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB81            ;

	RETURN                  ;

DU24    MOVF    TMPB,0          ; nach W
	SUBLW   D'153'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB71            ;
	
	MOVF    TMPB,0          ; nach W
	SUBLW   D'163'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB66            ;

	RETURN                  ;

FB75    MOVLW   D'75'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB83    MOVLW   D'83'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB87    MOVLW   D'87'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB81    MOVLW   D'81'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB71    MOVLW   D'71'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB66    MOVLW   D'66'           ;
	MOVWF   M16             ;


;*************************************************************************
; Tabellenabfragen MSB 0 // 8 // 17 // 25
;*************************************************************************

TES03   MOVF    TMPA,0          ; nach W
	SUBLW   D'0'            ; 0 ?
	BTFSC   STATUS,ZER      ;
	CALL    DU00            ;
	
	MOVF    TMPA,0          ; nach W
	SUBLW   D'8'            ; 8 ?
	BTFSC   STATUS,ZER      ;
	CALL    DU08            ;
	
	MOVF    TMPA,0          ; nach W
	SUBLW   D'17'           ; 17 ?
	BTFSC   STATUS,ZER      ;
	CALL    DU17            ;

	MOVF    TMPA,0          ; nach W
	SUBLW   D'25'           ; 25 ?
	BTFSC   STATUS,ZER      ;
	CALL    DU25            ;
	
	MOVF    M16,0          ; M16 anschauen
	BTFSS   STATUS,ZER      ; nichts dekodiert ? 0
	GOTO    TES0A           ;
	
	MOVLW   D'32'           ; dann SPACE
	MOVWF   M16             ; in M16        
	
TES0A   RETURN                  ; Tabellen Abfragen sind fertig

;*************************************************************************
	
DU00    MOVF    TMPB,0          ; nach W
	SUBLW   D'0'            ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB32            ;
	
	MOVF    TMPB,0          ; nach W
	SUBLW   D'1'            ;
	BTFSC   STATUS,ZER      ;
	CALL    FB95            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'25'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB76            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'92'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB86            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'130'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB84            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'131'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB73            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'153'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB67            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'197'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB90            ;

	RETURN                  ;

FB32    MOVLW   D'32'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB76    MOVLW   D'76'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB95    MOVLW   D'95'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB86    MOVLW   D'86'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB84    MOVLW   D'84'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB73    MOVLW   D'73'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB67    MOVLW   D'67'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB90    MOVLW   D'90'           ;
	MOVWF   M16             ;
	RETURN                  ;

;*************************************************************************

DU08    MOVF    TMPB,0          ; nach W
	SUBLW   D'32'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB49            ;
	
	MOVF    TMPB,0          ; nach W
	SUBLW   D'41'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB74            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'57'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB85            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'160'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB55            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'163'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB68            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'185'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB79            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'253'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB48            ;

	RETURN                  ;

FB49    MOVLW   D'49'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB74    MOVLW   D'74'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB85    MOVLW   D'85'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB55    MOVLW   D'55'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB68    MOVLW   D'68'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB79    MOVLW   D'79'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB48    MOVLW   D'48'           ;
	MOVWF   M16             ;
	RETURN                  ;

;*************************************************************************

DU17    MOVF    TMPB,0          ; nach W
	SUBLW   D'0'            ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB45            ;
	
	MOVF    TMPB,0          ; nach W
	SUBLW   D'152'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB70            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'153'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB69            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'169'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB50            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'184'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB80            ;

	RETURN                  ;

FB45    MOVLW   D'45'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB70    MOVLW   D'70'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB69    MOVLW   D'69'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB50    MOVLW   D'50'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB80    MOVLW   D'80'           ;
	MOVWF   M16             ;
	RETURN                  ;

;*************************************************************************

DU25    MOVF    TMPB,0          ; nach W
	SUBLW   D'48'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB52            ;
	
	MOVF    TMPB,0          ; nach W
	SUBLW   D'49'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB89            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'56'           ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB72            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'145'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB53            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'153'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB54            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'161'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB51            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'177'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB57            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'184'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB65            ;

	MOVF    TMPB,0          ; nach W
	SUBLW   D'185'          ; 
	BTFSC   STATUS,ZER      ;
	CALL    FB56            ;

	RETURN                  ;

FB52    MOVLW   D'52'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB89    MOVLW   D'89'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB72    MOVLW   D'72'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB53    MOVLW   D'53'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB54    MOVLW   D'54'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB51    MOVLW   D'51'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB57    MOVLW   D'57'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB65    MOVLW   D'65'           ;
	MOVWF   M16             ;
	RETURN                  ;

FB56    MOVLW   D'56'           ;
	MOVWF   M16             ;
	RETURN                  ;

;**************************************************************************
; NAME     : GETBY      
; FUNKTION : Routine holt 8 Bit vom Port_B,RXM1 ab, und legt das 
;            Ergebnis-Byte in OUTBYTE ab 
; EINGANG  : Port_A,0
; AUSGANG  : OUTBYTE
;**************************************************************************

GETBY   BTFSC   PORT_A,0        ; kommt die erste Null ?
	GOTO    GETBY           ; nochmal probieren
	CALL    DELAYH          ; eine halbe Bitdauer warten

	BTFSC   PORT_A,0        ; Startbit ok - noch da ?
	GOTO    GETBY           ; nochmal alles von vorn...

	MOVLW   08H             ; 8 Bits holen
	MOVWF   BITCNT          ; nach Bitcnt
	CLRF    OUTBYTE            ; Empfangsbyte loeschen

RXBT    CALL    DELAYF          ; ein Bit abwarten
	BTFSC   PORT_A,0     ; Status des Bits
	GOTO    ISHIR            ; 1 Bit
	BCF     STATUS,CARRY    ; 0 Bit
	GOTO    ROTR           ; weitermachen beim Bit-Rotieren

ISHIR    BSF     STATUS,0        ; Carry auf 1 setzen
ROTR    RRF     OUTBYTE,1            ; per Carry ein Bit ins TMPD holen
	DECFSZ  BITCNT,1        ; eins weg...
	GOTO    RXBT            ; naechstes Bit holen

	CALL    DELAYF          ; Bitdauer wegen Stoppbit abwarten

	RETURN                  ; zurueck zur aufrufenden Routine

;*************************************************************************
; NAME     : SENDB
; FUNKTION : Routine sendet 8 Bit im seriellen Protokoll ab
;            19200 Baud bei 10MHz, 8 Datenbits, keine Paritaet, 1 Stop-Bit
; EINGANG  : OUTBYTE
; AUSGANG  : Port_A,2
;*************************************************************************

SENDB   MOVLW   08H             ; Anzahl Datenbits - 8
	MOVWF   BITCNT          ; nach Bitcnt
	BCF     PORT_A,2        ; Start-Bit auf 0
	CALL    DELAYF          ; eine Bit-Zeit warten

TXBT    RRF     OUTBYTE,1       ; ein Bit ins Carry schieben
	BTFSC   STATUS,CARRY    ; 1 oder 0 ?
	GOTO    ISHI            ; 1 Bit
ISLO    BCF     PORT_A,2        ; 0 Bit senden
	CALL    DELAYF          ; eine Bit-Zeit warten
	GOTO    ROTAT           ;
ISHI    BSF     PORT_A,2        ; 1 Bit senden
	CALL    DELAYF          ; eine Bit-Zeit warten
	GOTO    ROTAT           ;

ROTAT   DECFSZ  BITCNT,1        ; eins weggesendet ...
	GOTO    TXBT            ; naechstes Bit holen

	BSF     PORT_A,2        ; Stop-Bit auf 1
	CALL    DELAYF          ; eine Bit-Zeit warten
	BSF     PORT_A,2        ; Stop-Bit auf 1    
	CALL    DELAYF          ; eine Bit-Zeit warten
	RETURN                  ; zurueck zur Routine

;*************************************************************************
; NAME     : DELAYF
; FUNKTION : Wartet die Zeitdauer eines Bits von 52,08us ab
;            Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
;            + 4 pro Loop -> (4*X)+8 Zyklen
; EINGANG  : -
; AUSGANG  : -
;*************************************************************************

DELAYF  MOVLW   01DH            ; Bitdelay nach W
	MOVWF   TMPX            ; nach TMPX
LOOP1   NOP                     ; nix tun
	DECFSZ  TMPX,1          ; eins weg ...
	GOTO    LOOP1           ; noch groesser Null
	RETURN

;*************************************************************************
; NAME     : DELAYH
; FUNKTION : Wartet die Zeitdauer eines halben Bits von 26,04us
;            Call (2), Mov-Zeug (2), letztes DECFSZ (2), Return (2)
;            + 4 pro Loop -> (4*X)+8 Zyklen
; EINGANG  : -
; AUSGANG  : -
;*************************************************************************

DELAYH  MOVLW   00FH            ; HalfBitDelay nach W
	MOVWF   TMPX            ; nach TMPX
LOOP2   NOP                     ; nix tun
	DECFSZ  TMPX,1          ; eins weg ...
	GOTO    LOOP2           ; noch groesser Null
	RETURN
	
;*************************************************************************
; SORT A
; Stelle 6 ; Stelle 2 
; 01 - 6 M ; 11 - 6 M 
; 01 - 5 C ; 11 - 5 C 
; 02 - 6 N ; 12 - 6 N 
; 02 - 4 H ; 12 - 4 H 
; 02 - 3 G ; 12 - 3 G 
; 02 - 2 A ; 12 - 2 A 
; 02 - 1 K ; 12 - 1 K 
; 02 - 0 B ; 12 - 0 B 
; 03 - 5 F ; 13 - 5 F 
; 03 - 4 E ; 13 - 4 E 
; 03 - 3 Q ; 13 - 3 Q 
; 03 - 1 J ; 13 - 1 J 
; 03 - 0 D ; 13 - 0 D 
;*************************************************************************

SORTA   CLRF    TMPA            ;
	CLRF    TMPB            ;
	
	BTFSC   T01,6           ;
	BSF     TMPA,4          ;
	BTFSC   T01,5           ;
	BSF     TMPA,3          ;
	BTFSC   T02,6           ;
	BSF     TMPA,2          ;
	BTFSC   T02,4           ;
	BSF     TMPA,1          ;
	BTFSC   T02,3           ;
	BSF     TMPA,0          ;
	
	BTFSC   T02,2           ;
	BSF     TMPB,7          ;
	BTFSC   T02,1           ;
	BSF     TMPB,6          ;
	BTFSC   T02,0           ;
	BSF     TMPB,5          ;
	BTFSC   T03,5           ;
	BSF     TMPB,4          ;
	BTFSC   T03,4           ;
	BSF     TMPB,3          ;
	BTFSC   T03,3           ;
	BSF     TMPB,2          ;
	BTFSC   T03,1           ;
	BSF     TMPB,1          ;
	BTFSC   T03,0           ;
	BSF     TMPB,0          ;

	RETURN                  ; zurueck
	
;*************************************************************************
; SORT B
; Stelle 5 ; Stelle 1
; 04 - 6 H ; 14 - 6 H
; 04 - 5 G ; 14 - 5 G
; 04 - 4 A ; 14 - 4 A
; 04 - 3 K ; 14 - 3 K
; 04 - 2 B ; 14 - 2 B
; 04 - 1 M ; 14 - 1 M
; 04 - 0 C ; 14 - 0 C
; 05 - 6 E ; 15 - 6 E
; 05 - 5 Q ; 15 - 5 Q
; 05 - 3 J ; 15 - 3 J
; 05 - 2 D ; 15 - 2 D
; 05 - 1 N ; 15 - 1 N
; 06 - 0 F ; 16 - 0 F
;*************************************************************************

SORTB   CLRF    TMPA            ;
	CLRF    TMPB            ;
	
	BTFSC   T01,1           ;
	BSF     TMPA,4          ;
	BTFSC   T01,0           ;
	BSF     TMPA,3          ;
	BTFSC   T02,1           ;
	BSF     TMPA,2          ;
	BTFSC   T01,6           ;
	BSF     TMPA,1          ;
	BTFSC   T01,5           ;
	BSF     TMPA,0          ;
	
	BTFSC   T01,4           ;
	BSF     TMPB,7          ;
	BTFSC   T01,3           ;
	BSF     TMPB,6          ;
	BTFSC   T01,2           ;
	BSF     TMPB,5          ;
	BTFSC   T03,0           ;
	BSF     TMPB,4          ;
	BTFSC   T02,6           ;
	BSF     TMPB,3          ;
	BTFSC   T02,5           ;
	BSF     TMPB,2          ;
	BTFSC   T02,3           ;
	BSF     TMPB,1          ;
	BTFSC   T02,2           ;
	BSF     TMPB,0          ;

	RETURN                  ; zurueck

;*************************************************************************
; SORT C
; Stelle 4 
; 06 - 6 A 
; 06 - 5 K 
; 06 - 4 B 
; 06 - 3 M 
; 06 - 2 C 
; 07 - 5 J 
; 07 - 4 D 
; 07 - 3 N 
; 07 - 1 H 
; 07 - 0 G 
; 08 - 2 F 
; 08 - 1 E 
; 08 - 0 Q 
;*************************************************************************

SORTC   CLRF    TMPA            ;
	CLRF    TMPB            ;
	
	BTFSC   T01,3           ;
	BSF     TMPA,4          ;
	BTFSC   T01,2           ;
	BSF     TMPA,3          ;
	BTFSC   T02,3           ;
	BSF     TMPA,2          ;
	BTFSC   T02,1           ;
	BSF     TMPA,1          ;
	BTFSC   T02,0           ;
	BSF     TMPA,0          ;
	
	BTFSC   T01,6           ;
	BSF     TMPB,7          ;
	BTFSC   T01,5           ;
	BSF     TMPB,6          ;
	BTFSC   T01,4           ;
	BSF     TMPB,5          ;
	BTFSC   T03,2           ;
	BSF     TMPB,4          ;
	BTFSC   T03,1           ;
	BSF     TMPB,3          ;
	BTFSC   T03,0           ;
	BSF     TMPB,2          ;
	BTFSC   T02,5           ;
	BSF     TMPB,1          ;
	BTFSC   T02,4           ;
	BSF     TMPB,0          ;

	RETURN                  ; zurueck

;*************************************************************************
; SORT D
; Stelle 3 
; 09 - 6 K 
; 09 - 5 B 
; 09 - 4 M 
; 09 - 3 C 
; 10 - 6 J 
; 10 - 5 D 
; 10 - 4 N 
; 10 - 2 H 
; 10 - 1 G 
; 10 - 0 A 
; 11 - 3 F 
; 11 - 2 E 
; 11 - 1 Q 
;*************************************************************************

SORTD   CLRF    TMPA            ;
	CLRF    TMPB            ;
	
	BTFSC   T01,4           ;
	BSF     TMPA,4          ;
	BTFSC   T01,3           ;
	BSF     TMPA,3          ;
	BTFSC   T02,4           ;
	BSF     TMPA,2          ;
	BTFSC   T02,2           ;
	BSF     TMPA,1          ;
	BTFSC   T02,1           ;
	BSF     TMPA,0          ;
	
	BTFSC   T02,0           ;
	BSF     TMPB,7          ;
	BTFSC   T01,6           ;
	BSF     TMPB,6          ;
	BTFSC   T01,5           ;
	BSF     TMPB,5          ;
	BTFSC   T03,3           ;
	BSF     TMPB,4          ;
	BTFSC   T03,2           ;
	BSF     TMPB,3          ;
	BTFSC   T03,1           ;
	BSF     TMPB,2          ;
	BTFSC   T02,6           ;
	BSF     TMPB,1          ;
	BTFSC   T02,5           ;
	BSF     TMPB,0          ;

	RETURN                  ; zurueck

	END                     ; das wars dann
